/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.init;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.BlockTempRegisterEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTempConfig;
import com.momosoftworks.coldsweat.api.temperature.block_temp.FurnaceBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.LavaBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.NetherPortalBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.SoulFireBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FireTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.UndergroundTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TempModifierInit {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void fireRegisterModifiers(ServerAboutToStartEvent event) {
        TempModifierInit.buildModifierRegistries();
    }

    public static void buildModifierRegistries() {
        TempModifierRegistry.flush();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new TempModifierRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering TempModifiers failed!");
            throw e;
        }
    }

    public static void buildBlockRegistries() {
        try {
            MinecraftForge.EVENT_BUS.post((Event)new BlockTempRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering BlockTemps failed!");
            throw e;
        }
    }

    public static void buildBlockConfigs() {
        for (List<?> effectBuilder : WorldSettingsConfig.getInstance().getBlockTemps()) {
            if (effectBuilder.size() < 3) {
                ColdSweat.LOGGER.error("Malformed configuration for block temperature: {}", effectBuilder);
                continue;
            }
            try {
                String str;
                Object obj;
                String str2;
                Object obj2;
                String[] blockIDs = ((String)effectBuilder.get(0)).split(",");
                Block[] effectBlocks = (Block[])Arrays.stream(blockIDs).map(xva$0 -> ConfigHelper.getBlocks(xva$0)).flatMap(Collection::stream).toArray(Block[]::new);
                final double blockTemp = ((Number)effectBuilder.get(1)).doubleValue();
                double blockRange = ((Number)effectBuilder.get(2)).doubleValue();
                double maxChange = effectBuilder.size() > 3 && effectBuilder.get(3) instanceof Number ? ((Number)effectBuilder.get(3)).doubleValue() : Double.MAX_VALUE;
                HashMap blockPredicates = effectBuilder.size() > 4 && (obj2 = effectBuilder.get(4)) instanceof String && !(str2 = (String)obj2).isEmpty() ? ConfigHelper.getBlockStatePredicates(effectBlocks[0], str2) : new HashMap();
                final NbtRequirement tag = effectBuilder.size() > 5 && (obj = effectBuilder.get(5)) instanceof String && !(str = (String)obj).isEmpty() ? new NbtRequirement(NBTHelper.parseCompoundNbt(str)) : new NbtRequirement();
                double tempLimit = effectBuilder.size() > 6 ? ((Number)effectBuilder.get(6)).doubleValue() : Double.MAX_VALUE;
                double maxEffect = blockTemp > 0.0 ? maxChange : Double.MAX_VALUE;
                double minEffect = blockTemp < 0.0 ? -maxChange : -1.7976931348623157E308;
                double maxTemperature = blockTemp > 0.0 ? tempLimit : Double.MAX_VALUE;
                double minTemperature = blockTemp < 0.0 ? tempLimit : -1.7976931348623157E308;
                BlockTempRegistry.register(new BlockTempConfig(minEffect, maxEffect, minTemperature, maxTemperature, blockRange, true, blockPredicates, effectBlocks){

                    @Override
                    public double getTemperature(Level level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
                        CompoundTag blockTag;
                        BlockEntity blockEntity = level.m_7702_(pos);
                        if (blockEntity != null && !tag.test((Tag)(blockTag = blockEntity.m_187480_()))) {
                            return 0.0;
                        }
                        return blockTemp;
                    }
                });
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Invalid configuration for BlockTemps", (Throwable)e);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerBlockTemps(BlockTempRegisterEvent event) {
        long startMS = System.currentTimeMillis();
        event.register(new LavaBlockTemp());
        event.register(new FurnaceBlockTemp());
        event.register(new NetherPortalBlockTemp());
        event.register(new SoulFireBlockTemp());
        ColdSweat.LOGGER.debug("Registered BlockTemps in {}ms", (Object)(System.currentTimeMillis() - startMS));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerTempModifiers(TempModifierRegisterEvent event) {
        long startMS = System.currentTimeMillis();
        String compatPath = "com.momosoftworks.coldsweat.api.temperature.modifier.compat.";
        String sereneSeasons = compatPath + "SereneSeasonsTempModifier";
        String armorUnder = compatPath + "ArmorUnderTempModifier";
        String weatherStorms = compatPath + "StormTempModifier";
        String curios = compatPath + "CuriosTempModifier";
        String valkyrienSkies = compatPath + "ValkShipBlockTempModifier";
        event.register(new ResourceLocation("cold_sweat", "blocks"), BlockTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "biomes"), BiomeTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "underground"), UndergroundTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "armor"), ArmorInsulationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "mount"), MountTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "waterskin"), WaterskinTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "soulspring_lamp"), SoulLampTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "water"), WaterTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "air_conditioning"), BlockInsulationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "food"), FoodTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "freezing"), FreezingTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "on_fire"), FireTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "soul_sprout"), SoulSproutTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "inventory_items"), InventoryItemsTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "entities"), EntitiesTempModifier::new);
        if (CompatManager.isSereneSeasonsLoaded()) {
            event.registerByClassName(new ResourceLocation("sereneseasons", "season"), sereneSeasons);
        }
        if (CompatManager.isArmorUnderwearLoaded()) {
            event.registerByClassName(new ResourceLocation("armorunder", "lining"), armorUnder);
        }
        if (CompatManager.isWeather2Loaded()) {
            event.registerByClassName(new ResourceLocation("weather2", "storm"), weatherStorms);
        }
        if (CompatManager.isCuriosLoaded()) {
            event.registerByClassName(new ResourceLocation("curios", "curios"), curios);
        }
        if (CompatManager.isValkyrienSkiesLoaded()) {
            event.registerByClassName(new ResourceLocation("valkyrienskies", "ship_blocks"), valkyrienSkies);
        }
        ColdSweat.LOGGER.debug("Registered TempModifiers in {}ms", (Object)(System.currentTimeMillis() - startMS));
    }
}

